# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.


from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl import fault_mode as ft
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.cli_common import get_system_version_without_ret
from psdk.checkitem.common.fru_common import is_selected_fan_in_disk_enclosure
from psdk.dsl.dsl_common import is_single_device


class CheckItem(BaseCheckItem):
    def execute(self):
        # 判断当前更换是否为硬盘框风扇
        self.logger.info(self.context.execute_env.selected_fru+"selected_fru")
        if is_selected_fan_in_disk_enclosure(self):
            self.logger.info("fan in disk enclosure, check pass")
            return CheckStatus.PASS, ""
        # 单控直接通过
        if is_single_device(self.dsl):
            return CheckStatus.PASS, ""
        # 获取版本信息
        flag, software_version, hot_patch_version = \
            get_system_version_without_ret(self.dsl("exec_cli 'show upgrade package'"))
        if software_version == "V500R007C60SPC300" and hot_patch_version[-3:] >= "312":
            return CheckStatus.PASS, ""
        synchronizing_list = []
        migrating_list = []
        # 分别查找是否存在迁移或远程复制状态
        remote_replications = self.dsl("exec_cli 'show remote_replication unified list_type=fs' | horizontal_parser",
                                       return_if={ft.FindException: []})
        append_id_by_target_name(remote_replications, "Synchronizing", synchronizing_list, "ID")
        fs_migrations = self.dsl("exec_cli 'show fs_migration general' | horizontal_parser",
                                 return_if={ft.FindException: []})
        append_id_by_target_name(fs_migrations, "Migrating", migrating_list, "Source FS ID")
        # 判断是否通过
        if not migrating_list and not synchronizing_list:
            return CheckStatus.PASS, ""
        if software_version == "V500R007C60SPC300":
            suggestion = self.get_msg("check.suggestion.upgrade", "V500R007C60SPH312")
        else:
            suggestion = self.get_msg("check.suggestion.other")
        error_str = self.get_msg("check.error.title")
        if migrating_list:
            error_str += self.get_msg("check.error.migrating", ", ".join(migrating_list))
        if synchronizing_list:
            error_str += self.get_msg("check.error.synchronizing", ", ".join(synchronizing_list))
        return CheckStatus.NOT_PASS, error_str+self.get_msg("check.suggestion.keyword")+suggestion


def append_id_by_target_name(origin_list, running_status, target_list, target_name):
    if origin_list:
        for item in origin_list:
            if item.get("Running Status") == running_status:
                target_list.append(item.get(target_name))
