# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


# apollo历史版本
APOLLO_HIS_VERSION = ["1.0.0.1", "1.1.1.0", "1.1.4.0", "1.1.5.0", "1.1.6.0", "1.1.7.0", "1.1.8.0"]

# apollo历史版本允许的最大控制器数量
MAX_CTRL_NUM = 16


class CheckItem(BaseCheckItem):
    def execute(self):
        try:
            expand_ctrl_num = self.context.execute_env.ori_env.get("expCtrl")
            apollo_version = self.get_apollo_version()
        except Exception as e:
            self.logger.error(str(e))
            return CheckStatus.NOT_CHECK, self.get_msg("check.get.param.error")

        if int(expand_ctrl_num) <= MAX_CTRL_NUM:
            return CheckStatus.PASS, ""
        if apollo_version not in APOLLO_HIS_VERSION:
            return CheckStatus.PASS, ""

        return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

    def get_apollo_version(self):
        """
        获取apollo版本
        @return: apollo版本
        """
        system_info = self.dsl("exec_cli 'show system general' | vertical_parser")
        apollo_version = system_info[0].get("OceanStor OS Kernel Version")
        if apollo_version:
            return apollo_version
        else:
            return system_info[0].get("OS Kernel Version")
