# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import re
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
MEMORY_UNIT_CONVERSION = 1024


class CheckItem(BaseCheckItem):
    def execute(self):
        mem_size = self.get_mem_size()
        if (int(mem_size) == 32 or int(mem_size) == 64):
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
        else:
            return CheckStatus.PASS, ""
            
    def get_mem_size(self):
        # 获取当前控制器内存信息(Cache Capacity),确定是否支持扩控
        results = self.dsl("exec_cli 'show controller general' | vertical_parser")
        capacity_info = results[0].get("Cache Capacity")
        if "TB" in capacity_info:
            cache_capacity = float(capacity_info.replace("TB", "")) * MEMORY_UNIT_CONVERSION
            return cache_capacity
        cache_capacity = float(capacity_info.replace("GB", ""))
        return cache_capacity
