# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft
from psdk.platform.util.base_util import get_common_msg


class CheckItem(BaseCheckItem):
    def execute(self):
        ret = self.dsl("exec_on_all {}", self.check_controller_scale_in_status, target_ctrl="master")
        for local_exp_status in ret.values():
            if local_exp_status == 'not_check':
                return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "query.result.abnormal")
            if local_exp_status == 'ScaleIn':
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""

    def check_controller_scale_in_status(self):
        return self.dsl("exec_mini_system 'sys.sh showlocalexpstatus' | regex 'LocalExpStatus:\s*(\w+)' | get_index(0)",
                        end_str_list=["minisystem>", "minisystem> "], return_if={ft.FindStr("Error"): "not_check"})
