# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version


def is_dorado_evice(self):
    return 'Dorado' in self.context.dev_node.model


def get_ssd_disk_domain(self):
    ssd_disk_domain = []
    dd_info = self.dsl("exec_cli 'show disk_domain general |"
                       "filterColumn include columnList=ID' | horizontal_parser")
    disk_domains = [item.get("ID") for item in dd_info]

    for dd in disk_domains:
        if is_dorado_evice(self):   # dorado一定是纯闪dd
            ssd_disk_domain.append(dd)
            continue
        dd_detail_info = self.dsl("exec_cli 'show disk_domain general disk_domain_id={}' | vertical_parser".format(dd))
        for line in dd_detail_info:
            if line.get("Disk Number") == '0':
                ssd_disk_domain.append(dd)
    return ssd_disk_domain


class CheckItem(BaseCheckItem):
    def execute(self):
        version_info = get_version_info(self.dsl)
        base_version = version_info.get("base_version").get("Current Version")
        if base_version != "6.1.6":
            return CheckStatus.PASS, "not risk version"
        patch_version = version_info.get("patch_version").get("Current Version")
        if compare_patch_version(patch_version, "SPH22") >= 0:
            return CheckStatus.PASS, "patch already installed"

        ssd_disk_domain = get_ssd_disk_domain(self)
        risk_dd = []
        for dd in ssd_disk_domain:
            show_dp = self.dsl("exec_diagnose 'pmgr showdp -d {}' | vertical_parser".format(dd))
            for line in show_dp:
                if line.get("dynamicOpStatus") == "1":
                    risk_dd.append(dd)
        if len(risk_dd) == 0:
            return CheckStatus.PASS, "no risk dd"

        return CheckStatus.NOT_PASS, "need install patch risk dd {}".format(risk_dd)