# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.platform.util.base_util import get_common_msg

SUCCESS = 0
CHECK_CARD_STATUS_FAILED = 1


class CheckItem(BaseCheckItem):

    def execute(self):
        # 检查方法步骤1：以admin用户登录设备
        # 若不是超级管理员用户，则检查结果为检查未完成
        if not self.is_supper_admin():
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "loginUser.name.level.must.be.super.admin")
        # 检查方法步骤2：执行命令 show upgrade package，获取软件版本和热补丁版本
        if self.check_version():
            return CheckStatus.PASS, ""
        # 步骤6 遍历所有控制器执行步骤3到步骤5
        # 检查方法步骤6：若步骤5中所有控制器不存在Drv type: 2的回显，则检查通过，否则检查不通过
        results = self.dsl("exec_on_all {}", self.check_dtoe_card_status)
        for _, check_status in results.items():
            if check_status != SUCCESS:
                return CheckStatus.NOT_PASS, self.get_err_msg("dtoe.check.not.pass", "dtoe.suggestion")
        return CheckStatus.PASS, ""

    def check_version(self):
        # 若步骤2中软件版本和热补丁版本满足下列关系之一，则检查通过，否则继续检查
        # 6.1.5：SPH8或其之后补丁
        # 1.2.0：SPH8或其之后补丁
        # 由于设置执行环境为615和120，因此只需要检查补丁版本大于SPH8即可，若执行条件变更，需要同步修改补丁判断条件
        version_info = get_version_info(self.dsl)
        # 获取产品版本和补丁版本,获取不到产品版本和补丁版本返回不通过
        sph_version = version_info.get("patch_version").get("Current Version")
        if compare_patch_version(sph_version, "SPH8") >= 0:
            return True
        return False

    def check_dtoe_card_status(self):
        # 步骤3和步骤4封装于dsl命令
        # 检查方法步骤5：执行命令 dtoe showcardinfo，查询是否存在Drv type: 2回显
        dtoe_result = self.dsl("exec_diagnose 'dtoe showcardinfo'")
        # 不存在drv_type为2的回显，则检查通过
        if dtoe_result.find("Drv type: 2") == -1:
            return SUCCESS
        return CHECK_CARD_STATUS_FAILED

