# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):

        # 不存在存储池，则检查通过
        storage_pools = self.dsl("exec_cli 'show storage_pool general' | horizontal_parser")
        if not storage_pools:
            return CheckStatus.PASS, ""

        domain_ids = [item.get("Disk Domain ID") for item in storage_pools]

        cross_domain_ids = self.check_is_cross_engine_expand_disk(domain_ids)
        if not cross_domain_ids:
            return CheckStatus.PASS, ""

        fsmig_info_ids = self.get_fs_migration_domain_id()
        if not fsmig_info_ids[0]:
            return CheckStatus.PASS, ""

        return_job_ids = []
        final_domain_ids = self.check_exist_fs_migration(cross_domain_ids, fsmig_info_ids[0])
        if not final_domain_ids:
            return CheckStatus.PASS, ""
        
        # 0->fsmig_domain_ids 1->job_ids, 2->fs_ids, 3->pool_ids_out, 4->domain_ids_out
        index = 0
        for item in fsmig_info_ids[4]:
            if item in final_domain_ids:
                return_job_ids.append(fsmig_info_ids[1][index])
            index = index + 1
        return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", ",".join(return_job_ids))

    def check_is_cross_engine_expand_disk(self, domain_ids):

        cross_eng_domain_ids = []
        expand_infos = self.get_expand_disk_engines()
        if not expand_infos:
            return cross_eng_domain_ids

        expand_infos_real = {}
        for pool_id in expand_infos:
            real_domain_id = self.get_domain_id(pool_id)
            expand_infos_real[real_domain_id] = expand_infos[pool_id]

        local_infos = self.get_logic_disk_engines(domain_ids)
        for domain_id in expand_infos_real:
            if domain_id not in local_infos:
                continue
            for item in expand_infos_real[domain_id]:
                if item not in local_infos[domain_id]:
                    cross_eng_domain_ids.append(domain_id)
                    break
        return cross_eng_domain_ids

    def get_domain_id(self, pool_id):
        pool_info = self.dsl("exec_cli 'show storage_pool general pool_id={}' "
                                  "| vertical_parser".format(pool_id))
        disk_domain_id = pool_info[0].get("Disk Domain ID")
        return disk_domain_id

    def get_expand_disk_engines(self):
        """
        获取扩盘的引擎信息
        """
        disk_engines = {}
        exp_disk_list = self.context.execute_env.ori_env.get("exp_disk_list")
        if not exp_disk_list:
            exp_disk_list = self.context.execute_env.ori_env.get("expDiskList")
        if not exp_disk_list:
            return disk_engines
        for exp_disk in exp_disk_list:
            # 新建硬盘域场景，硬盘域id为空，这种场景不检查
            disk_domain = exp_disk.get("diskDomain")
            if not disk_domain or disk_domain == 'none':
                continue
            if disk_domain not in disk_engines:
                disk_engines[disk_domain] = []
            disk_engines[disk_domain].append(exp_disk.get("eng"))
        return disk_engines

    def get_logic_disk_engines(self, domain_ids):
        """
        获取当前指定硬盘域的引擎
        """
        disk_engines = {}
        for domain_id in domain_ids:
            dd_results = self.dsl("exec_cli 'show disk_domain general disk_domain_id={}' "
                                  "| vertical_parser".format(domain_id))
            enclosure = dd_results[0].get("Controller enclosure")
            if enclosure:
                disk_engines[domain_id] = enclosure.split(",")
        return disk_engines

    def get_fs_migration_domain_id(self):

        fsmig_domain_ids = []
        migration_info = self.dsl("exec_cli 'show fs_migration general' | horizontal_parser")
        if not migration_info:
            return [fsmig_domain_ids]
        job_ids = [item.get("Job Id") for item in migration_info]
        fs_ids = [item.get("Local FS ID") for item in migration_info]

        file_system_info = self.dsl("exec_cli 'show file_system general' | horizontal_parser")
        all_fs_ids = [item.get("ID") for item in file_system_info]
        all_pool_ids = [item.get("Pool ID") for item in file_system_info]
        pool_ids = []
        pool_ids_out = []
        for item in fs_ids:
            if all_pool_ids[all_fs_ids.index(item)] not in pool_ids:
                pool_ids.append(all_pool_ids[all_fs_ids.index(item)])
            pool_ids_out.append(all_pool_ids[all_fs_ids.index(item)])

        storage_pools = self.dsl("exec_cli 'show storage_pool general' | horizontal_parser")
        all_pool_ids2 = [item.get("ID") for item in storage_pools]
        all_domain_ids = [item.get("Disk Domain ID") for item in storage_pools]
        domain_ids_out = []
        for item in pool_ids:
            if all_domain_ids[all_pool_ids2.index(item)] not in fsmig_domain_ids:
                fsmig_domain_ids.append(all_domain_ids[all_pool_ids2.index(item)])
        for item in pool_ids_out:
            domain_ids_out.append(all_domain_ids[all_pool_ids2.index(item)])

        return [fsmig_domain_ids, job_ids, fs_ids, pool_ids_out, domain_ids_out]

    def check_exist_fs_migration(self, cross_domain_ids, fsmig_domain_ids):

        final_domain_ids = []
        for item in cross_domain_ids:
            if item in fsmig_domain_ids:
                final_domain_ids.append(item)
        return final_domain_ids
