# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl import fault_mode as ft
from psdk.platform.util.base_util import get_common_msg

# 6.1.3和6.1.5解决新融合扩控数据不一致问题的补丁
PASS_VERSIONS = {"6.1.3": "SPH30", "6.1.5": "SPH16"}
HDD_DISK_TYPES = ("SAS", "NearLine SAS", "SAS SED", "NearLine SAS SED")


class CheckItem(BaseCheckItem):
    def execute(self):
        member_disk_num = 0
        # 获取硬盘信息
        member_disk_infos = \
            self.dsl("exec_cli 'show disk general |filterColumn include columnList=ID,Type,Role'"
                     " | horizontal_parser", return_if={ft.CmdNoSupport: "not_check", ft.FindStr("Error"): "not_check"})
        if member_disk_infos == 'not_check':
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "query.result.abnormal")
        for member_disk_info in member_disk_infos:
            if member_disk_info.get("Type") not in HDD_DISK_TYPES:
                continue
            # 如果盘为HDD且为Member Disk，则直接进行下一步检查
            if member_disk_info.get("Role") == "Member Disk":
                member_disk_num += 1
                break
        if member_disk_num == 0:
            return CheckStatus.PASS, ""
        # 获取版本信息
        version_info = get_version_info(self.dsl)
        cur_version = version_info.get("base_version").get("Current Version")
        patch_version = version_info.get("patch_version").get("Current Version")
        sver = cur_version[:len("6.1.3")]
        # 版本为6.1.3.SPH30及其之后的版本，则检查通过
        if compare_patch_version(patch_version, PASS_VERSIONS.get(sver)) >= 0:
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", cur_version)
