# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2022. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version

not_pass_dict = {
    "V300R002C20": ["V300R002C20SPH002", "V300R002C20SPH006"],
    "V300R002C10SPC100": ["V300R002C10SPH109", "V300R002C10SPH129"]
}


class CheckItem(BaseCheckItem):
    def execute(self):
        # 获取基本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        base_version = version_info.get("base_version").get("Current Version")
        history_version = version_info.get("base_version").get("History Version")

        # 执行检查
        if (base_version in not_pass_dict) and (history_version != "--") and (patch_version != "--"):
            if compare_patch_version(patch_version, not_pass_dict[base_version][0]) >= 0 and \
                    compare_patch_version(not_pass_dict[base_version][1], patch_version) >= 0:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_SUPPORT, ""
