# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import re
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):
        # 获取基本信息
        version_info = get_version_info(self.dsl)
        version = version_info.get("base_version").get("Current Version")

        # 需要检查一下版本范围
        if version != "1.1.0":
            self.logger.info("this is not 1.1.0")
            return CheckStatus.PASS, ""

        infos = self.dsl("exec_cli 'show file_system general' | horizontal_parser",
                         return_if={ft.FindStr("Error:"): "not_check"})
        if infos == "not_check":
            return CheckStatus.NOT_CHECK, ""

        if not infos:
            return CheckStatus.PASS, ""
        for info in infos:
            variable_segment = info.get("Variable Segment")
            # 1.1.0实际测试不为8KB 或 16KB的时候为--
            if variable_segment != "8KB" and variable_segment != "16KB":
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""
