# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import re
import ast

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    container_card_list = []
    err_card_list = []

    def execute(self):
        # 若不是超级管理员用户，则检查结果为检查未完成
        if not self.is_supper_admin():
            return CheckStatus.NOT_CHECK, self.get_msg("loginUser.name.level.must.be.super.admin")

        # 查询容器卡数量
        card_str = self.dsl("exec_cli 'show interface_module'")
        selected_ctrl = ast.literal_eval(self.context.execute_env.selected_fru)
        ctrl_id = selected_ctrl.get("id", "").strip()
        cte_num = re.search(r'(\d)[A-D]', ctrl_id)

        pattern = re.compile(r"\s(.*?CTE{}.IOM\.[HL]\d+)\s+.*?Running.*?\sContainer\s".format(cte_num.group(1)))
        self.container_card_list = pattern.findall(str(card_str))
        if len(self.container_card_list) <= 6:
            return CheckStatus.PASS, ""

        # 提供窗口供客户选择
        from com.huawei.ism.tool.bizpack.wizardparse.intf import GetUserInputImpl
        dialog = GetUserInputImpl()
        rec = dialog.showYesNoDialog(self.get_msg("check.ctrl.time.dialog"))

        # 弹框点击“取消”，检查不通过
        if not rec:
            self.get_container_card_by_ctrl_id(ctrl_id)

            err_args = str(len(self.container_card_list)), ",".join(self.err_card_list)
            err = self.get_err_msg("check.not.pass", "item.suggestion", err_args)
            return CheckStatus.NOT_PASS, err
        # 弹框点击“确定”，检查通过
        else:
            return CheckStatus.PASS, ""

    # 通过控制器ID得到需要拔出的容器卡
    def get_container_card_by_ctrl_id(self, ctrl_id):
        ctrl_type = re.search(r'\d([A-D])', ctrl_id)
        if not ctrl_type:
            return

        if ctrl_type.group(1) == 'A':
            self.get_container_card(r'H(\d+)', 0, 6)  # H0-H6
        elif ctrl_type.group(1) == 'B':
            self.get_container_card(r'L(\d+)', 0, 6)  # L0-L6
        elif ctrl_type.group(1) == 'C':
            self.get_container_card(r'H(\d+)', 7, 13)  # H7-H13
        elif ctrl_type.group(1) == 'D':
            self.get_container_card(r'L(\d+)', 7, 13)  # L7-L13
        return

    # 得到需要拔出的容器卡
    def get_container_card(self, find_str, slot_start, slot_end):
        for card_id in self.container_card_list:
            num = re.search(find_str, card_id)
            if not num:
                continue
            if (int(num.group(1)) >= slot_start) and (int(num.group(1)) <= slot_end):
                self.err_card_list.append(card_id)
