# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
import os
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.checkitem.check_item_mgr import read_json_file

MODEL = (
    'HSSD-D7594DL7T6N', 'HSSD-D7594DL7T6E', 'HSSD-D7294DL3T8N', 'HSSD-D7294DL3T8E', 'HSSD-D7284PV1T6N',
    'HSSD-D7294DL7T6N', 'HSSD-D7294DL7T6E', 'HSSD-D7584PV1T6N', 'HSSD-D7523AL3T8N', 'HSSD-D7223AL3T8N',
    'HSSD-D7223AL3T8E', 'HSSD-D7223AL7T6N', 'HSSD-D7223AL7T6E', 'HSSD-D7523AL7T6N'
)


class CheckItem(BaseCheckItem):

    def execute(self):
        current_dir = os.path.dirname(__file__)
        parent_dir = os.path.dirname(current_dir)
        config_map = read_json_file(os.path.join(parent_dir, "common", "hssd_check_list.json"))

        large_set_risk_high = set(config_map.get('need_check_list_2026_2027'))
        large_set_risk_mid = set(config_map.get('need_check_list_2035_2036'))

        # 执行指定命令show disk general
        disk_info_list = self.dsl("exec_cli 'show disk general|filterColumn include "
                                  "columnList=ID,Type,Model,Firmware\\sVersion,Serial\\sNumber'| horizontal_parser")

        if not disk_info_list:
            return CheckStatus.PASS, ""
        not_pass_lst = []
        for disk in disk_info_list:
            fw = disk.get("Firmware Version")
            sn = disk.get("Serial Number")
            mn = disk.get("Model")
            if mn not in MODEL or not fw.isdigit():
                continue

            # 问题解决版本固件是8318，只要固件大于该该版本，就认为无异常，直接continue
            if int(fw) >= int(8318):
                continue

            if sn in large_set_risk_high or sn in large_set_risk_mid:
                not_pass_lst.append(disk.get("ID"))

        lst = []
        if not_pass_lst:
            lst.append(self.get_msg("check.not.pass", ", ".join(not_pass_lst)))

        rlt = "\n".join(lst)

        if not_pass_lst:
            return CheckStatus.NOT_PASS, rlt
        else:
            return CheckStatus.PASS, ""

