# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):
        hyper_metro_ret = self.dsl("exec_cli 'show hyper_metro_vstore_pair general' | horizontal_parser")
        if not hyper_metro_ret:
            return CheckStatus.PASS, ""
        for hyper_metro in hyper_metro_ret:
            local_vid = hyper_metro.get("Local Vstore ID")
            remote_vid = hyper_metro.get("Remote Vstore ID")
            if local_vid != remote_vid:
                cli_ret = self.dsl("exec_cli 'change vstore view id={}'".format(local_vid))
                if "successfully" not in cli_ret:
                    continue
                v41_enabled = self.dsl("exec_cli 'show service nfs' | horizontal_parser"
                                       "| get_key('Support V41 Enabled')")
                self.dsl("exec_cli 'exit'")
                if not v41_enabled:
                    continue
                if v41_enabled[0] == "On":
                    return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""
