# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2022. All rights reserved.


from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version

ERR_HOT_PATCH = {"6.0.1": "SPH28", "6.1.0": "SPH20", "6.1.2": "SPH9", "1.1.0": "SPH1"}


class CheckItem(BaseCheckItem):
    """
    控制器配套检查
    :return: (检查结果，错误提示信息）
    """

    def execute(self):
        return self.check_risk_version()

    def check_risk_version(self):
        version_info = get_version_info(self.dsl)
        hot_patch_version = version_info.get("patch_version").get(
            "Current Version"
        )
        software_version = version_info.get("base_version").get(
            "Current Version"
        )

        if software_version not in ERR_HOT_PATCH:
            err_msg_key = \
                "check.not.pass.dorado" if "Dorado" in self.context.dev_node.model else "check.not.pass.protect"
            err_msg = self.get_msg(
                err_msg_key, software_version, hot_patch_version,
            )
            return CheckStatus.NOT_PASS, err_msg
        target_hot_patch = ERR_HOT_PATCH.get(software_version)
        if compare_patch_version(hot_patch_version, target_hot_patch) >= 0:
            return CheckStatus.PASS, ""
        return (
            CheckStatus.NOT_PASS,
            self.get_msg(
                "check.not.pass.patch",
                software_version,
                hot_patch_version,
                target_hot_patch,
            ),
        )
