# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2013-2023. All rights reserved.

import re

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):
        logic_ports = \
            self.dsl(
                "exec_cli 'show port general logic_type=Management_Port physical_type=ETH running_status=link_up'"
                "| horizontal_parser",
                return_if={ft.FindStr("Error:"): "not_check"})
        if logic_ports == "not_check":
            return CheckStatus.NOT_CHECK, self.get_msg("query.result.abnormal")

        ip_ports = []
        for line in logic_ports:
            if line.get("IPv4 Address") == "--" and \
                    line.get("IPv6 Address") == "--":
                continue

            port_id = line.get("ID")
            ip_ports.append(port_id)

        if not ip_ports:
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")

        plane_value = [False, False]
        plane = 2
        for port in ip_ports:
            for i in range(plane):
                self.net_check_mgt_is_redundant(port, plane_value, i)

            if plane_value[0] and plane_value[1]:
                return CheckStatus.PASS, ""

        return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")

    def net_check_mgt_is_redundant(self, port, value, plane):
        if plane == 0:
            if re.findall(r"CTE\d+\.A\.MGMT", port) or \
                    re.findall(r"CTE\d+\.SMM0\.MGMT\d", port):
                value[0] = True

        if plane == 1:
            if re.findall(r"CTE\d+\.B\.MGMT", port) or \
                    re.findall(r"CTE\d+\.SMM1\.MGMT\d", port):
                value[1] = True
