# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl.dsl_common import get_version_info
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):
        # 获取基本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")

        # 6.1.0安装了SPH15及以后补丁，通过
        if version == "6.1.0" and \
                compare_patch_version(patch_version, "SPH15") >= 0:
            return CheckStatus.PASS, ""

        # 检查方法步骤1：使用dsl执行命令查询框的信息
        enclosures = self.dsl("exec_cli 'show enclosure' | horizontal_parser",
                              return_if={ft.FindStr("Error:"): "not_check"})
        if self.is_not_check(enclosures):
            return CheckStatus.NOT_CHECK, self.get_msg("query.result.abnormal")
        cte_enclosure_ids = [enclosure.get("ID") for enclosure in enclosures if
                             enclosure.get("ID").startswith("CTE")]
        if len(cte_enclosure_ids) < 2:
            return CheckStatus.PASS, ""

        # 检查方法步骤2：使用dsl执行命令查询绑定端口信息
        bond_port_info = self.dsl("exec_cli 'show bond_port'")
        if 'No matching records' in bond_port_info:
            return CheckStatus.PASS, ""

        # 检查方法步骤3：使用dsl执行命令查询端口信息
        local_ports = \
            self.dsl("exec_cli 'show logical_port general' | horizontal_parser",
                     return_if={ft.FindStr("Error:"): "not_check"})
        if self.is_not_check(local_ports):
            return CheckStatus.NOT_CHECK, self.get_msg("query.result.abnormal")
        for local_port in local_ports:
            if local_port.get("Home Port Type") != "Bond" and \
                    local_port.get("Current Port Type") != "Bond":
                continue
            if "NFS" in local_port.get("Support Protocol") or \
                    "CIFS" in local_port.get("Support Protocol"):
                self.logger.info(self.get_err_msg("check.not.pass", "item.suggestion"))

                return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
        return CheckStatus.PASS, ""

    @staticmethod
    def is_not_check(record):
        """
        检查命令执行结果是否为NOT_CHECK
        :param record: 命令执行结果
        :return:
        """
        return record == "not_check"
