# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):
        # 1、获取产品型号
        system_general_info = self.dsl("exec_cli 'show system general' | vertical_parser")
        product_model = system_general_info[0].get("Product Model")

        if product_model == "OceanStor A800":
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
    
