# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.rest.rest_common_service import RestCommonService
import com.huawei.ism.tool.framework.pubservice.entity.DevNode as DevNode


class CheckItem(BaseCheckItem):
    def execute(self):
        tlv_cmd = 55834624000
        param_dict = [[{"index": 0, "type": 'uint32'}, 207]]
        dev = self.context.java_dev
        sn = dev.getDeviceSerialNumber()
        if sn.startswith("21"):
            dev.setDeviceSerialNumber("22" + sn[2:])
        rest_service = RestCommonService(self.context.java_dev)
        records = rest_service.exec_tlv_cmd(tlv_cmd, param_dict)
        self.logger.info("Check new controller status:{}".format(records))
        for record in records:
            health_status = int(record.get("7").get("value"))
            running_status = int(record.get("8").get("value"))
            # health_status不为normal或running_status不为online，检查不通过
            if health_status != 1 or running_status != 27:
                return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
        return CheckStatus.PASS, ""
