# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.rest.rest_common_service import RestCommonService
from a800_util import exec_tlv_cmd_by_dev_node


class CheckItem(BaseCheckItem):
    def execute(self):
        zone_id = self.context.execute_env.ori_env.get("zoneId")
        origin_zone_map = self.context.execute_env.ori_env.get("originZoneMap")
        dev_node = origin_zone_map.get(zone_id) # 获取原集群zone的devNode
        if not dev_node:
            return CheckStatus.PASS, ""
        new_disk_cert_records = self.get_cert_on_new_ctrl()
        if new_disk_cert_records is None:
            return CheckStatus.PASS, ""
        err_cert_label = self.check_cert_on_origin_ctrl(new_disk_cert_records, dev_node)
        if err_cert_label:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", err_cert_label[0])
        return CheckStatus.PASS, ""

    def get_cert_on_new_ctrl(self):
        tlv_cmd = 59594908143
        param = []
        dev = self.context.java_dev
        sn = dev.getDeviceSerialNumber()
        if sn.startswith("21"):
            dev.setDeviceSerialNumber("22" + sn[2:])
        rest_service = RestCommonService(self.context.java_dev)
        return rest_service.exec_tlv_cmd(tlv_cmd, param)
    
    def check_disk_cert(self, cert_label, cert_content, dev_node):
        tlv_cmd = 59594908144
        params = []
        param0 = [{"index": 1, "type": 'string'}, cert_label]
        params.append(param0)
        param1 = [{"index": 2, "type": 'string'}, cert_content]
        params.append(param1)
        return exec_tlv_cmd_by_dev_node(tlv_cmd, params, dev_node)
    
    def check_cert_on_origin_ctrl(self, new_disk_cert_records, dev_node):
        err_cert_label = []
        for record in new_disk_cert_records:
            cert_label = record.get("1").get("value")
            cert_content = record.get("2").get("value")
            result_record = self.check_disk_cert(cert_label, cert_content, dev_node)
            if result_record is not None:
                break
            if result_record is None:
                err_cert_label.append(cert_label)
                continue
            res = int(result_record[0].get("3").get("value"))
            if res == 0:
                err_cert_label.append(cert_label)
        return err_cert_label
