# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.rest.rest_common_service import RestCommonService
import com.huawei.ism.tool.framework.pubservice.entity.DevNode as DevNode


class CheckItem(BaseCheckItem):
    def execute(self):
        tlv_cmd = 55847747746
        param_dict = []
        self.logger.info("Check new ibc key pair dev node{}".format(self.context.java_dev))
        dev = self.context.java_dev
        sn = dev.getDeviceSerialNumber()
        if sn.startswith("21"):
            dev.setDeviceSerialNumber("22" + sn[2:])
        rest_service = RestCommonService(self.context.java_dev)
        records = rest_service.exec_tlv_cmd(tlv_cmd, param_dict)
        ibc_key_pair_changed = records[0].get("1").get("value")
        if int(ibc_key_pair_changed) == 1:
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
        return CheckStatus.PASS, ""
