# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus

A800_CHECK_ALARM_WHITELIST = set([
    '0xD80001', # 存储池剩余容量不足 0xF00D80158/0xF00D80119
    '0xD80002', # 存储池容量即将耗尽 0xF00D80120/	0xF00D80166/	0xF00D80159
    '0xF00280047',  # 文件系统剩余容量不足。重要 	0xF0028012D
    '0xF00D80114', # 存储池剩余容量不足 0xF00D80158/0xF00D80119
    '0xF00D80148',  # 可得容量消耗不符合预期 	0xF00D80148
    '0xF00E00038',  # 存储池可用空间耗尽。紧急(无)  0xF00280126 文件系统可用空间耗尽 	0xF0028012E 审计日志文件系统空间耗尽
    '0xF01050015', # 交换机无法监控 0xF00CF0076 系统无法监控控制器 	0xF0CE0001 系统无法监控硬盘框
    '0xF010A0059',  # 硬盘域热备空间不足。重要 	0xF010A0066
    '0xF0D80004',  # 存储池热备空间不足。重要 （无）
])


class CheckItem(BaseCheckItem):

    def execute(self):
        '''
        @summary: 检查设备上是否存在特定告警
        '''
        res = self.dsl("exec_cli 'show alarm|filterColumn include columnList=ID'| horizontal_parser")
        # 沒有告警则通过
        if not res:
            return CheckStatus.PASS, ""
        # 有白名单中的告警则不通过，否则通过
        alm_id_list = list()
        for alm_id in res:
            if alm_id["ID"] in A800_CHECK_ALARM_WHITELIST:
                alm_id_list.append(alm_id["ID"])
        # 如果不为空则需要给出提示
        if alm_id_list:
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion", \
                err_args=(",".join(alm_id_list)))
        return CheckStatus.PASS, ""