# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version

PASS_VERSIONS = {"6.1.3": "SPH26", "6.1.5": "SPH18", "1.2.0": "SPH18"}


class CheckItem(BaseCheckItem):
    def check_mpdk_info_node(self):
        return self.dsl("exec_diagnose 'mpdk showpartinfo -s 0' | splitlines")


    def execute(self):
        version_info = get_version_info(self.dsl)
        base_version = version_info.get("base_version").get("Current Version")
        patch_version = version_info.get("patch_version").get("Current Version")
        for version, patch in PASS_VERSIONS.items():
            if base_version == version and \
                    compare_patch_version(patch_version, patch) >= 0:
                return CheckStatus.PASS, ""

        mpdk_partition = self.dsl("exec_on_all {}", self.check_mpdk_info_node)
        match_node = []
        for node_id, node_info in mpdk_partition.items():
            for item in node_info:
                if not (("ISCSI" in item) and ("NIC" in item) and ("NIC_USR" not in item)):
                    continue
                cpu_map = item.split()
                if cpu_map[5] == "0x0" and cpu_map[6] == "0x0" and cpu_map[7] == "0x0":
                    cur_version = base_version + '.' + patch_version if \
                        patch_version and patch_version != '--' else base_version
                    match_node.append(node_id)

        if match_node:
            ret_node_info = ", ".join(match_node)
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", cur_version, ret_node_info)

        return CheckStatus.PASS, ""
