# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version

NEED_CHECK_BASE_VERSION_612 = "6.1.2"
NEED_CHECK_PATCH_VERSION_LOW_612 = "SPH32"
NEED_CHECK_PATCH_VERSION_HIGH_612 = "SPH33"
NEED_CHECK_BASE_VERSION_613 = "6.1.3"
NVME_ENCRYPTED_DISK_TYPE = "NVMe SSD SED"
AUTO_LOCK_STATE_ON = "ON"


class CheckItem(BaseCheckItem):

    def execute(self):
        # 步骤2 获取系统软件版本和热补丁版本
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")

        if version == NEED_CHECK_BASE_VERSION_612:
            if patch_version == NEED_CHECK_PATCH_VERSION_LOW_612 or patch_version == NEED_CHECK_PATCH_VERSION_HIGH_612:
                need_suggest = self.has_nvme_disk_encrypted_domain()
                if need_suggest:
                    return CheckStatus.WARNING, self.get_msg("check.not.pass", version, patch_version)

        if version == NEED_CHECK_BASE_VERSION_613:
            if compare_patch_version(patch_version, "SPH10") >= 0 >= compare_patch_version(patch_version, "SPH13"):
                need_suggest = self.has_nvme_disk_encrypted_domain()
                if need_suggest:
                    return CheckStatus.WARNING, self.get_msg("check.not.pass", version, patch_version)

        return CheckStatus.PASS, ""

    def has_nvme_disk_encrypted_domain(self):
        """
        检查是否有使用NVMe加密盘创建了加密硬盘域(有NVMe加密盘且AutoLock状态为on)
        """
        disk_info_list = self.dsl("exec_cli 'show disk general|filterColumn include columnList=ID,Disk\sDomain\sID,"
                                  "Type,AutoLock\sState'"
                                  " | horizontal_parser")
        for disk_info in disk_info_list:
            disk_type = disk_info.get("Type")
            auto_lock_state = disk_info.get("AutoLock State")
            if disk_type == NVME_ENCRYPTED_DISK_TYPE and auto_lock_state == AUTO_LOCK_STATE_ON:
                return True
        return False
