# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import ast
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl.dsl_common import get_version_info


class CheckItem(BaseCheckItem):
    def execute(self):
        # 查询盘类型
        selected_disk = ast.literal_eval(self.context.execute_env.selected_fru)
        disk_type = str(selected_disk.get("diskType"))
        if "NVME" not in disk_type.upper() and "SCM" not in disk_type:
            return CheckStatus.PASS, ""

        # 查询系统软件版本和热补丁版本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")

        # 6.1.2版本并且补丁版本在SPH8以下并且需要更换nvme/scm盘，告警
        target_patch_version = "SPH8"
        if compare_patch_version(patch_version, target_patch_version) < 0:
            product_version = version
            if "SPH" in patch_version:
                product_version = "{}.{}".format(version, patch_version)
            err_msg = self.get_err_msg("check.not.pass", "item.suggestion", (product_version, disk_type))
            return CheckStatus.NOT_PASS, err_msg
        return CheckStatus.PASS, ""
