# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
import re

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus

MAX_OMTASK_ACCEPT_QUEUE = 128


class CheckItem(BaseCheckItem):
    def execute(self):

        if self.check_remote_device_not_existed():
            return CheckStatus.PASS, ""

        if self.check_omtask_accept_queue():
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""

    def check_remote_device_not_existed(self):
        """
        检查是否有远端设备，有则继续，否则退出
        """
        cli_ret = self.dsl("exec_cli 'show remote_device general array_type=replication'")
        return "No matching records" in cli_ret

    def check_omtask_accept_queue_in_main(self):
        """
        在主控检查127.0.0.1:2525的接收队列数目是否大于等于128，是则存在问题。否则无问题
        """
        accept_queue = 0
        result = self.dsl("exec_mini_system 'netstat -tpnl' | splitlines ")
        for item in result:
            if "127.0.0.1:2525" in item and "LISTEN" in item:
                accept_queue = int(re.split(r"\s+", item)[1])
                break
        return accept_queue > MAX_OMTASK_ACCEPT_QUEUE

    def check_omtask_accept_queue(self):
        """
        检查队列是否异常
        """
        result = False
        netstat_infos = self.dsl("exec_on_all {}", self.check_omtask_accept_queue_in_main, target_ctrl="master")
        for item in netstat_infos.values():
            if isinstance(item, bool) and item:
                result = True
                return result
        return result
