# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version


class CheckItem(BaseCheckItem):
    @staticmethod
    def judge_oceanstor_version(version, patch_version):
        # OceanStor补丁小于6.1.6 SPH10则不通过
        if "6.1.7" == version and compare_patch_version(patch_version, "SPH2") < 0:
            return True
        # OceanStor补丁小于6.1.7 SPH2则不通过
        if "6.1.6" == version and compare_patch_version(patch_version, "SPH10") < 0:
            return True
        return False

    def execute(self):

        # 1、获取基线和补丁版本号
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")

        # 2、获取产品型号
        system_general_info = self.dsl("exec_cli 'show system general' | vertical_parser")
        product_model = system_general_info[0].get("Product Model")

        # 3、判断补丁版本
        # OceanStor 2910补丁小于6.1.6 SPH2 则不通过
        if "OceanStor 2910" in product_model and "6.1.6" == version \
                and compare_patch_version(patch_version, "SPH2") < 0:  # SPH2 为解决问题补丁版本
            return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")  # item.suggestion为修复建议
        # OceanDisk补丁小于1.1.0 SPH6 则不通过
        if "OceanDisk" in product_model and "1.1.0" == version \
                and compare_patch_version(patch_version, "SPH6") < 0:  # SPH6 为解决问题补丁版本
            return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")  # item.suggestion为修复建议
        # OceanProtect补丁小于1.3.0 SPH10 则不通过
        if "OceanProtect" in product_model and "1.3.0" == version \
                and compare_patch_version(patch_version, "SPH10") < 0:  # SPH10 为解决问题补丁版本
            return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")  # item.suggestion为修复建议
        # OceanProtect补丁小于1.5.0 SPH2 则不通过
        if "OceanProtect" in product_model and "1.5.0" == version \
                and compare_patch_version(patch_version, "SPH2") < 0:  # SPH2 为解决问题补丁版本
            return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")  # item.suggestion为修复建议
        # OceanStor Dorado场景
        if "OceanStor Dorado" in product_model and self.judge_oceanstor_version(version, patch_version):
            return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")  # item.suggestion为修复建议

        # OceanStor包含了2910，需排除
        if "OceanStor" in product_model and "OceanStor 2910" != product_model \
                and self.judge_oceanstor_version(version, patch_version):
            return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")  # item.suggestion为修复建议

        return CheckStatus.PASS, ""




