# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import re

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.entity.execute_env import UpgradeExecuteEnv, ExpansionExecuteEnv
from psdk.platform.util.base_util import format_msg, get_common_msg
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_version, compare_patch_version

MAX_SAFE_PERF_SIZE = 0x2800000000


class CheckItem(BaseCheckItem):

    def check_version_if_need_check(self):
        version_info = get_version_info(self.dsl)
        software_version = version_info.get("base_version").get("Current Version")
        hotpatch_version = version_info.get("patch_version").get("Current Version")

        if ((compare_version(software_version, '6.1.3') == 0) and 
            # 相等为0，左边的版本号大于右边是1，小于右边是-1
            (compare_patch_version(hotpatch_version, 'SPH22') < 0)):
            return True
        if ((compare_version(software_version, '6.1.5') == 0) and 
             (compare_patch_version(hotpatch_version, 'SPH12') < 0)):
            return True
        return False

    def check_every_storage_pool_if_need_warning(self):

        cli_ret = self.dsl("exec_diagnose 'pmgr showdp' | horizontal_parser")
        local_pool_list = [int(item.get('disk pool id'), 16) for item in cli_ret]

        #检查每个存储池是否需要告警
        for pool_managed_id in local_pool_list:
            cli_ret = self.dsl("exec_diagnose 'bm vdbmgr show vdbmgrobj -s {}'".format(pool_managed_id))
            pattern = r"ShareDataVdb *\| *0x[0-9a-f]* *\| *?(0x[0-9a-f]*)"
            perf_real_size = int(re.findall(pattern, cli_ret)[0], 16)
            if (perf_real_size > MAX_SAFE_PERF_SIZE):
                return True
        
        return False


    def execute(self):

        # 检查产品型号 版本信息
        if not self.check_version_if_need_check():
            return CheckStatus.PASS, ""

        # 检查所有存储池是否需要告警
        if self.check_every_storage_pool_if_need_warning():
            return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")
        return CheckStatus.PASS, ""
