# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    @staticmethod
    def is_smart_qos_policy_has_map(smart_qos_info):
        """
        检查标准2：判断是否存在qos策略且存在映射
        """
        for policy in smart_qos_info:
            if policy.get("Filesystem List", "") != "--":
                return True
        return False

    def execute(self):
        # 检查方法步骤1：使用dsl执行命令查询qos信息
        smart_qos_info = self.dsl("exec_developer 'show smartqos_policy general' | horizontal_parser")
        if not self.is_smart_qos_policy_has_map(smart_qos_info):
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
