# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):
        not_pass_ctrl_ids = []
        ctrl_ids = self.dsl("exec_developer  'show controller general |filterColumn include columnList=Controller' | "
                            "vertical_parser | get_key('Controller')")
        for ctrl_id in ctrl_ids:
            grain_num_info = self.dsl(
                "exec_developer  'show zone_rebuild grain controller={}' | vertical_parser".format(ctrl_id))
            if not grain_num_info:
                continue
            grain_num = int(grain_num_info[0].get("Zone Rebuild Grain Num", 0))
            # 找出不是2的幂次方的grain_num
            if (grain_num & (grain_num - 1)) != 0:
                not_pass_ctrl_ids.append(ctrl_id)

        if not not_pass_ctrl_ids:
            return CheckStatus.PASS, ""

        err_msg = self.get_msg("item.notpass", ", ".join(not_pass_ctrl_ids))
        return CheckStatus.NOT_PASS, err_msg
