# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl.dsl_common import get_version_info


class CheckItem(BaseCheckItem):
    def execute(self):
        # 查询系统软件版本和热补丁版本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")
        # 6.0.1安装了SPH21及以后补丁，通过
        if version == "6.0.1" and \
                compare_patch_version(patch_version, "SPH21") >= 0:
            return CheckStatus.PASS, ""
        # 6.1.0安装了SPH15及以后补丁，通过
        if version == "6.1.0" and \
                compare_patch_version(patch_version, "SPH15") >= 0:
            return CheckStatus.PASS, ""

        notify_msg = []
        # 检查方法步骤3：执行命令"show remote_replication unified"查询远程复制pair信息
        rep_pair_info = self.dsl("exec_cli 'show remote_replication unified' | horizontal_parser")
        invalid_rep_pairId = self.get_invalid_pair(rep_pair_info)
        if invalid_rep_pairId:
            notify_msg.append(self.get_notify_msg(version, patch_version, "check.not.pass.rep", invalid_rep_pairId))
        # 检查方法步骤4：执行命令"show hyper_metro_pair general"查询双活信息
        hc_pairInfo = self.dsl("exec_cli 'show hyper_metro_pair general' | horizontal_parser")
        invalid_hc_pairId = self.get_invalid_pair(hc_pairInfo)
        if invalid_hc_pairId:
            notify_msg.append(self.get_notify_msg(version, patch_version, "check.not.pass.hc", invalid_hc_pairId))

        if notify_msg:
            return CheckStatus.NOT_PASS, '\n'.join(notify_msg)

        return CheckStatus.PASS, ""

    @staticmethod
    def get_invalid_pair(pair_info):
        """
        检查标准1：是否有无效的pair
        """
        return [pair.get("ID") for pair in pair_info if pair.get("Running Status") == "Invalid"]

    def get_notify_msg(self, version, patch_version, notify_item, invalid_pairid):
        cur_version = version + '.' + patch_version if patch_version and patch_version != '--' else version
        pairid_list = ",".join(invalid_pairid)
        return self.get_msg(notify_item, cur_version, pairid_list)
