# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft
from psdk.platform.util.base_util import get_common_msg


class CheckItem(BaseCheckItem):
    def execute(self):
        ret = self.dsl("exec_cli 'show smart_move general'",
                       return_if={ft.CmdNoSupport: "not_support", ft.FindStr("Error:"): "not_check"})
        if ret == "not_check":
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "query.result.abnormal")
        if ret == "not_support" or 'No matching records' in ret:
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
