# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

import re
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version

pass_version_dic = {
    "6.1.3": "SPH7"
}


class CheckItem(BaseCheckItem):
    def execute(self):
        # 步骤1 若步骤2中的软件版本为6.1.3，补丁版本小于SPH7则继续检查，否则检查通过；
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        base_version = version_info.get("base_version").get("Current Version")

        if base_version in pass_version_dic and compare_patch_version(patch_version,
                                                                      pass_version_dic.get(base_version)) >= 0:
            return CheckStatus.PASS, ""
        if base_version not in pass_version_dic:
            return CheckStatus.PASS, ""

        # 步骤2 执行命令：show performance_layer general，查询当前smartcache配置情况；
        results = self.dsl("exec_cli 'show performance_layer general'")
        match_pattern = "No matching records"
        if re.compile(match_pattern).findall(results):
            return CheckStatus.PASS, ""

        # 步骤3 执行命令：show file_system general，查询当前smartcache配置情况；
        results = self.dsl("exec_cli 'show file_system general'")
        if re.compile(match_pattern).findall(results):
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_msg("item.not_pass")
