# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from decimal import Decimal
import re
import sys
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
reload(sys)
sys.setdefaultencoding('utf8')


class CheckItem(BaseCheckItem):
    def execute(self):
        total_capacity = Decimal('0')  # 初始化为0
        error_info = ""
        is_hybird_flash = False
        id_string = "ID"  # ID 为盘框槽号，直接使用门禁无法通过

        # 执行指定命令show disk general
        disk_general = self.dsl("exec_cli 'show disk general |filterColumn include columnList=ID,Running\sStatus,"
                               "Type,Capacity,Degree\sof\sWear(%),Run\sTime(Day),Capacity\sUsage(%),"
                               "Estimated\sLife\sRemaining(Month),Role' | horizontal_parser")
        for disk in disk_general:
            if "Member Disk" != disk.get("Role"):
                continue
            if "SSD" not in disk.get("Type"):
                is_hybird_flash = True
                continue
            capacity_num = re.findall("\d+\.?\d*", disk.get("Capacity"))[0]  # 容量一般不为空,获取数值
            capacity_unit = re.findall("[A-Za-z]+", disk.get("Capacity"))[0]  # 容量一般不为空，获取单位
            total_capacity = self.total_capacity_add(total_capacity, capacity_num, capacity_unit)

        for disk in disk_general:
            if self.disk_is_pass(disk):
                continue
            if is_hybird_flash:
                error_info = error_info +\
                             self.get_msg("check.not.pass.hybirdflash", disk.get(id_string)) + "\n"  # ID 为盘框槽号
                continue
            ret = self.is_need_expansion(total_capacity, disk.get(id_string))  # ID 为盘框槽号
            if ret:
                error_info = error_info + ret
            else:
                error_info = error_info +\
                             self.get_msg("check.not.pass.upgrade", disk.get(id_string)) + "\n"  # ID 为盘框槽号

        if error_info:
            return CheckStatus.WARNING, error_info

        return CheckStatus.PASS, ""

    @staticmethod
    def lifetime_end(disk):
        """
        判断硬盘的寿命巡检是否正常
        @param disk: 硬盘信息
        @return: 硬盘寿命巡检是否正常
        """
        degree_of_wear = Decimal(disk.get("Degree of Wear(%)")) * Decimal(100)  # 磨损率去掉百分号
        life_remaining_num = re.findall("\d+\.?\d*", disk.get("Estimated Life Remaining(Month)"))[0]  # 可能会出现 >60 字符串
        life_remaining = Decimal(life_remaining_num) * Decimal(30 * 24)  # 剩余生命(月)折算成小时
        run_time = Decimal(disk.get("Run Time(Day)")) * Decimal(24)  # 运行天数(天)折算成小时
        wear_10_percent = Decimal(1000)  # 磨损10% * 100
        life_5_year = Decimal(5 * 12 * 30 * 24)  # 5年折算成小时
        if life_remaining >= life_5_year or degree_of_wear <= wear_10_percent:
            return False
        if run_time and run_time + life_remaining < life_5_year:
            return True
        return False

    @staticmethod
    def total_capacity_add(total_capacity, capacity_num, capacity_unit):
        #  单位一般只有TB、GB，统一折算成GB，
        if "TB" == capacity_unit:
            return total_capacity + Decimal(capacity_num) * Decimal(1024)  # 1024为容量单位换算值
        else:
            return total_capacity + Decimal(capacity_num)

    def disk_is_pass(self, disk):
        if "Member Disk" != disk.get("Role"):
            return True
        if "SSD" not in disk.get("Type"):
            return True
        if 'Online' != disk.get("Running Status"):
            return True
        if not self.lifetime_end(disk):
            return True
        return False

    def is_need_expansion(self, total_capacity, disk_id):
        # 条件1：容量使用率大于80
        storage_pool_list = self.dsl("exec_cli 'show storage_pool general |filterColumn "
                                     "include columnList=ID,Used\sCapacity\sPercent(%)' | horizontal_parser")
        for storage_pool in storage_pool_list:
            used_capacity_percent = Decimal(storage_pool.get("Used Capacity Percent(%)"))
            if used_capacity_percent > Decimal(80):  # 80容量利用率
                return self.get_msg("check.not.pass.expansion.usage", disk_id) + "\n"

        # 条件2：前端带宽(Write Bandwidth: 所有控制器加起来) * 放大率(3) * 3600 * 24 >= 所有成员盘总容量（所有盘相加）
        controller_list = self.dsl("exec_cli 'show controller general' | vertical_parser")
        controller_id_list = list()
        for controller in controller_list:
            controller_id_list.append(controller.get("Controller"))
        controller_id_list_str = ",".join(controller_id_list)
        sdl_str = "exec_cli 'show performance controller controller_id_list=" + \
                 controller_id_list_str + " mode=controller_default times=1' | horizontal_parser"
        performance_controller_list = self.dsl(sdl_str)
        total_write_bandwidth = Decimal(0)
        for item in performance_controller_list:
            total_write_bandwidth += Decimal(item.get("Write Bandwidth(MB/s)"))
        total_write_bandwidth_compare = total_write_bandwidth * Decimal(3 * 3600 * 24)  # 3为放大倍数，3600秒一小时，24小时一天
        total_capacity_compare = total_capacity * Decimal(1024)  # 转换为MB，与写入带宽保持一致
        if total_write_bandwidth_compare >= total_capacity_compare:
            return self.get_msg("check.not.pass.expansion.bandwidth", disk_id) + "\n"
        return ""
