# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.
from psdk.checkitem.common.system_disk_risk import CheckSystemDiskLifeItem

from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.base_util import get_common_msg


class CheckItem(CheckSystemDiskLifeItem):
    def execute(self):
        if not self.is_supper_admin():
            return CheckStatus.NOT_CHECK, get_common_msg(self.lang, "loginUser.name.level.must.be.super.admin")
        results = self.dsl("exec_on_all {}", self.get_drive_life)
        result = max(results.values())
        if int(result) == 1:
            return CheckStatus.WARNING, self.get_msg("check.suggestion", ";\n".join(self.not_pass_ctrl_list))
        if int(result) == 2:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", ";\n".join(self.not_pass_ctrl_list))
        return CheckStatus.PASS, ""
