# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus

SINGLE_USER_MAP_COUNT_MAX = 1000
TOTAL_USER_MAP_COUNT_MAX = 4000


class CheckItem(BaseCheckItem):
    def execute(self):
        license_ret = self.dsl("exec_cli 'show license'")
        if "NFS Protocol" not in license_ret:
            if "CIFS Protocol" not in license_ret:
                return CheckStatus.PASS, ""
        user_map_count = self.cal_user_map_count()
        if user_map_count >= SINGLE_USER_MAP_COUNT_MAX:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        if user_map_count == -1:
            return CheckStatus.PASS, ""
        total_user_map_count = 0
        total_user_map_count += user_map_count
        v_store_ret = self.dsl("exec_cli 'show vstore|filterColumn include columnList=ID'"
                               "| horizontal_parser | get_key('ID')")
        for item in v_store_ret:
            cli_ret = self.dsl("exec_cli 'change vstore view id={}'".format(item))
            if "successfully" not in cli_ret:
                continue
            user_map_count = self.cal_user_map_count()
            self.dsl("exec_cli 'exit'")
            if user_map_count >= SINGLE_USER_MAP_COUNT_MAX:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
            total_user_map_count += user_map_count
            if total_user_map_count >= TOTAL_USER_MAP_COUNT_MAX:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""

    def cal_user_map_count(self):
        user_map_count_ret = (self.dsl("exec_cli 'show identity_mapping rule_count' | vertical_parser"))
        if user_map_count_ret:
            user_map_count_num = user_map_count_ret[0].get("Number")
            if user_map_count_num:
                user_map_count = int(user_map_count_num)
            else:
                user_map_count = 0
        else:
            user_map_count = -1
        return user_map_count
