# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):
        user_partitions = self.dsl("exec_developer 'show cache_partition general' | horizontal_parser")
        if not user_partitions:
            return CheckStatus.PASS, ""

        # 统计每个引擎上用户分区写页面内存大小
        user_partition_write_size_dict = {}
        for user_partition in user_partitions:
            pair_id = user_partition.get("Storage Engine Id")
            write_size_mb = user_partition.get("Expect Write Size(MB)")
            if not user_partition_write_size_dict.get(pair_id):
                user_partition_write_size_dict[pair_id] = int(write_size_mb)
            else:
                user_partition_write_size_dict[pair_id] += int(write_size_mb)

        # 统计不合理的Storage Engine Id
        user_partition_invalid_storage_engine_id_list = []
        for pair_id in user_partition_write_size_dict.keys():

            # pair内节点个数为2
            ctrl_num_in_pair = 2
            ctrl_id = str(int(pair_id) * ctrl_num_in_pair)

            # 高端设备一个引擎最多4个控制器
            ctrl_num_in_engine = 4
            engine_id = int(int(pair_id) * ctrl_num_in_pair / ctrl_num_in_engine)
            default_partition_write_page_num = self.dsl("exec_on_all {}", self.query_default_partition_write_size,
                                                        target_ctrl={str(engine_id): [ctrl_id]})

            # write_size为pair总的写页面大小，单位为MB，一个页面大小为4KB，因此单控的写页面数:总页面大小 * 1024 / 4 / 2 = 总页面 * 128
            user_partition_write_size_to_write_page_num_ratio = 128
            user_partition_write_page_num = \
                user_partition_write_size_dict[pair_id] * user_partition_write_size_to_write_page_num_ratio

            default_num = [value for value in default_partition_write_page_num.values()][0]
            total_partition_write_page_num = user_partition_write_page_num + default_num

            # 用户分区写页面大小如果超过总页面的40%，则检查不通
            one_hundred_percent = 100
            forty_percent = 40
            if user_partition_write_page_num * one_hundred_percent > total_partition_write_page_num * forty_percent:
                user_partition_invalid_storage_engine_id_list.append(pair_id)

        if user_partition_invalid_storage_engine_id_list:
            return CheckStatus.NOT_PASS, \
                   self.get_err_msg("check.not.pass", "item.suggestion",
                                    err_args=",".join(user_partition_invalid_storage_engine_id_list))

        return CheckStatus.PASS, ""

    def query_default_partition_write_size(self):
        quotas = self.dsl("exec_diagnose 'quota show pttinfo 0' | splitlines")
        for quota in quotas:
            if "PTT_VOL_DIRTY" in quota:
                return int(quota.split()[2])

        # 不可能进入该分支，如果进入，返回一个很大的值，让检查通过。
        return 4294967295
