# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
import os
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.checkitem.check_item_mgr import read_json_file


class CheckItem(BaseCheckItem):

    def execute(self):
        current_dir = os.path.dirname(__file__)
        parent_dir = os.path.dirname(current_dir)
        config_map = read_json_file(os.path.join(parent_dir, "common", "hssd_v5_check_list.json"))

        risk_range_set = set(config_map.get('need_check_risk_list'))

        # 执行指定命令show disk general
        disk_info_list = self.dsl("exec_cli 'show disk general|filterColumn include "
                                  "columnList=ID,Type,Model,Firmware\\sVersion,Serial\\sNumber'| horizontal_parser")

        if not disk_info_list:
            return CheckStatus.PASS, ""
        not_pass_lst = []
        for disk in disk_info_list:
            fw = disk.get("Firmware Version")
            sn = disk.get("Serial Number")
            if not fw.isdigit():
                continue

            # 问题解决版本固件是3261，只要固件大于等于该该版本，就认为无异常，直接continue
            if int(fw) >= int(3261):
                continue
            if sn in risk_range_set:
                not_pass_lst.append(disk.get("ID"))

        not_pass_lst.sort()

        if not_pass_lst:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", ", ".join(not_pass_lst))
        else:
            return CheckStatus.PASS, ""

