# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.util.product_util import compare_patch_version

CHECK_612_FLAG_PATCH_START_VERSION = "SPH22"
CHECK_612_FLAG_PATCH_END_VERSION = "SPH30"


class CheckItem(BaseCheckItem):

    def execute(self):
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        if not ((compare_patch_version(patch_version, CHECK_612_FLAG_PATCH_START_VERSION) >= 0) and
                (compare_patch_version(patch_version, CHECK_612_FLAG_PATCH_END_VERSION) <= 0)):
            return CheckStatus.PASS, ""
        result_info = self.dsl("exec_diagnose 'xnet showconnstatusinqueue' | splitlines")
        for item in result_info:
            flag = ("ctx_index" in item) or ("-----" in item) or (">" in item) or ("showconnstatusinqueue" in item)
            if flag:
                continue
            if (int(item.split()[1], 16) == 2) and (int(item.split()[10]) > 0):
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""
