# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.checkitem.scripts import zero_op_disk_comm
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):

        if zero_op_disk_comm.judge_patch_version(self.dsl):
            op_disk_cnt = zero_op_disk_comm.calc_zero_op_disk(self.dsl)
            if op_disk_cnt > 100:  # 100原问题出现的盘数阈值
                return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")
            if op_disk_cnt > 0:
                return CheckStatus.WARNING, self.get_msg("item.suggestion")
        return CheckStatus.PASS, ""

