# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):
        ret_list = self.dsl("exec_cli 'show call_home general' | vertical_parser",
                            return_if={ft.CmdNoSupport: "notSupport", ft.FindStr("Error:"): "not_check"})
        if "notSupport" in ret_list:
            return CheckStatus.PASS, ""

        if "not_check" in ret_list:
            raise Exception("no check")

        for ret in ret_list:
            if str(ret.get("Switch Status", "")).lower() == "on" \
                    and str(ret.get("Is Authenticated", "")).lower() == "yes":
                return CheckStatus.PASS, ""

        ret_list = self.dsl("exec_cli 'show notification trap' | horizontal_parser",
                            return_if={ft.CmdNoSupport: "notSupport", ft.FindStr("Error:"): "not_check"})
        if "notSupport" in ret_list:
            return CheckStatus.PASS, ""

        if "not_check" in ret_list:
            raise Exception("no check")

        if [ret for ret in ret_list if ret.get("Server Port", "") == "10162"]:
            return CheckStatus.PASS, ""

        return CheckStatus.WARNING, self.get_msg("check.not.pass")
