# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import re

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.execute_env import UpgradeExecuteEnv, ExpansionExecuteEnv

# 12G SAS级联框对应BOM中Item值
elec_label_item_list = [
    '02312NRQ', '02312NCE', '02312HVH', '02312NRP', '02312NCD', '02312HVG', '02350RMH', '02351QTS', '02351HHW',
    '02351QTV', '02351QTL', '02351NYA', '02351QTM', '02351WYE', '02351NYB', '02351AXJ', '02351QPT', '02351CSL',
    '02351QUU', '02351HAQ', '02351HBD', '02351PBT', '02351QTK', '02351QUT', '02351QUW', '02351RHD', '02351XAV',
    '02351JML', '02351WLT', '02351RBR', '02351XBA', '02351XBE', '02351SAH', '02351XKF', '02351XKE', '02352AKP',
    '02352AKN', '02352AKR', '02352AKS', '02352EJU', '02352EJV', '02352EJW', '02352HFH', '02352HFJ', '02352HFK',
    '02352SRA', '02352LQM', '02352MHU', '02352SQY', '02352SRB', '02352SRC', '02352LQN', '02352VET', '02353LQU',
    '02353QHR', '02353LQT', '02353QHQ', '02352MPL', '02352BFF', '02352BGT', '02352CNY', '02352HCG', '02352BFL',
    '02352MPK', '02352HCD', '02352PYL', '02352BFG', '02352CPC', '02352MPN', '02352PYK', '02352BFK', '02354GQE',
    '02354GQJ', '02354GQM', '02354GQL', '02354GQS'
]


class CheckItem(BaseCheckItem):
    def execute(self):
        scene_info = self.context.execute_env.scene_value
        if scene_info.get("subScene") != "Expansion Disk" or scene_info.get("stepID") != "PostInspector":
            return CheckStatus.PASS, ""
        version_info = get_version_info(self.dsl)
        if not version_info:
            self.logger.info("no version info. check pass")
            return CheckStatus.PASS, ""
        # 获取产品版本和补丁版本,获取不到产品版本和补丁版本返回不通过
        pro_version = version_info.get("base_version").get("Current Version")
        sph_version = version_info.get("patch_version").get("Current Version")
        if not pro_version or not sph_version:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass.version")
        # 判断当前版本是否为V500R007C61以及补丁版本是否大于V500R007C61SPH022或者是否为V300R002C10SPC100以及补丁版本是否大于V300R002C10SPH126直接默认通过
        if (pro_version == 'V500R007C61' and sph_version > 'V500R007C61SPH022') or\
                (pro_version == 'V300R002C10SPC100' and sph_version > 'V300R002C10SPH126'):
            self.logger.info("no version info. check pass")
            return CheckStatus.PASS, ""
        # 检查方法步骤1：使用dsl执行命令查询框的信息
        enclosures = self.dsl("exec_developer 'show enclosure' | horizontal_parser")
        dae_enclosure_ids = [enclosure.get("ID") for enclosure in enclosures if enclosure.get("ID").startswith("DAE")]
        if not dae_enclosure_ids:
            self.logger.info("no DAE enclosures. check pass")
            return CheckStatus.PASS, ""
        # 检查方法步骤2：使用dsl执行命令检查每个框的电子标签中item字段是否在对应的列表中，在则返回检查不通过，否则返回检查通过
        for dae_enclosure_id in dae_enclosure_ids:
            enclosure_info = self.dsl(
                "exec_developer 'show enclosure enclosure_id={}' | regex 'Electronic Label[\\s\\S]+Item=(?P<elabel>[\w]+)'".format(
                    dae_enclosure_id))
            if not enclosure_info:
                self.logger.info("no enclosure info. check pass")
                return CheckStatus.PASS, ""
            elec_label = enclosure_info.get("elabel")
            # 电子标签字符串值在该列表中则直接命中，返回不通过
            if elec_label in elec_label_item_list:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass.elabel")
        return CheckStatus.PASS, ""
