# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_engine_height
from psdk.platform.util.product_util import get_ctrl_id_by_node_id


class CheckItem(BaseCheckItem):
    def execute(self):
        results = self.dsl("exec_on_all {}", self.check_dpumm_usage_sgl)
        abnormal_ctrls = []
        engine_height = get_engine_height(self.dsl, self.context)
        for node_id, leak_count in results.items():
            # 内存使用异常大于100
            if leak_count > 100:
                ctrl_id = get_ctrl_id_by_node_id(node_id, engine_height)
                abnormal_ctrls.append(ctrl_id)
        if abnormal_ctrls:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass", ",".join(abnormal_ctrls))
        return CheckStatus.PASS, ""

    def check_dpumm_usage_sgl(self):
        # 检查方法：执行命令diagnose dpumm_shm show usage sgl检查LeakedCount数
        results = self.dsl(
            "exec_diagnose 'dpumm_shm show usage sgl' | splitlines | regex '335\s+FSIO\s+\d+\s+(?P<LeakedCount>\d+)'")

        for result in results:
            return int(result.get("LeakedCount"))
        return 0
