# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
import re
import ast

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.checkitem.common.power_replace_common import self_exit, check_subrack_type


class CheckItem(BaseCheckItem):
    def execute(self):
        # 对于风扇模块，如果后续也要做该检查项，注意风扇模块可以多选，并且可能object_id参数中有空格
        selected_fru = ast.literal_eval(self.context.execute_env.selected_fru)
        # 获取name值
        object_name = selected_fru.get("name", "")
        script_name = 'power_replace_before_power_status_check'
        try:
            if not check_subrack_type(self, object_name, script_name):
                return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass.subract", "item.suggestion.subract")
            self.logger.info(script_name + " start!")
            return self.check_power_status()
        finally:
            self_exit(self, script_name)

    # 电源编码、状态、功率检查
    def check_power_status(self):
        # 电源编码查询
        power_psu0_num = self.dsl("exec_mini_system 'eam.sh psu_upgrade_get_psu_huaweicode 1000 0'")
        power_psu1_num = self.dsl("exec_mini_system 'eam.sh psu_upgrade_get_psu_huaweicode 1001 0'")

        # 电源编码检查
        if '02312HGY' not in power_psu0_num or '02312HGY' not in power_psu1_num:
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass.code", "item.suggestion.code")
        power_status = self.dsl("exec_mini_system 'eam.sh psu_upgrade_psu_state_check'")
        if '0x00' in power_status:
            # 电源功率查询
            power_psu0_pow_info = self.dsl("exec_mini_system 'eam.sh psu_upgrade_avgpower_check 1000 0'")
            power_psu1_pow_info = self.dsl("exec_mini_system 'eam.sh psu_upgrade_avgpower_check 1001 0'")
            # 获取回显中"power："开始的信息
            power_psu0_pow = re.search(r'power:\d+', power_psu0_pow_info).group()
            power_psu1_pow = re.search(r'power:\d+', power_psu1_pow_info).group()
            # 获取具体功率数值
            index_psu0 = power_psu0_pow.index("power:") + 6
            index_psu1 = power_psu1_pow.index("power:") + 6
            psu0_pow = int(power_psu0_pow[index_psu0:])
            psu1_pow = int(power_psu1_pow[index_psu1:])
            if psu0_pow and psu1_pow:
                power_total = psu0_pow + psu1_pow
                if psu0_pow < (power_total * 0.1) or psu1_pow < (power_total * 0.1):
                    return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass.power", "item.suggestion.power")
                else:
                    return CheckStatus.PASS, ""
            else:
                return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass.power", "item.suggestion.power")
        else:
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass.state", "item.suggestion.state")
