# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.dsl.dsl_common import get_version_info
from psdk.platform.entity.check_status import CheckStatus

from psdk.platform.util.product_util import compare_patch_version

PASS_CACHE_CAPACITY = 64
pass_version_dic = {
    "6.1.2": "SPH22",
    "6.1.3": "SPH7"
}
MEMORY_UNIT_CONVERSION = 1024
NO_FILE_SYSTEM = "No matching records"


class CheckItem(BaseCheckItem):
    def execute(self):
        # 步骤1  满足以下任意调节则检查结果通过  1）软件版本为6.1.2，补丁版本大于等于SPH22； 2）软件版本为6.1.3，补丁版本大于等于SPH7；
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        base_version = version_info.get("base_version").get("Current Version")

        if base_version in pass_version_dic and compare_patch_version(patch_version,
                                                                      pass_version_dic.get(base_version)) >= 0:
            return CheckStatus.PASS, ""

        # 步骤2 执行命令：show file_system general，查询当前文件系统信息
        file_system_info = self.dsl("exec_cli 'show file_system general'")
        if NO_FILE_SYSTEM in file_system_info:
            return CheckStatus.PASS, ""

        # 步骤3 执行命令：show cache data_intelligent_service，查看智能数据服务读缓存开关是否开启
        results = self.dsl("exec_developer 'show cache data_intelligent_service' | vertical_parser")
        read_cache_switch = results[0].get("Read Cache Switch")
        if read_cache_switch == "Enable":
            return CheckStatus.PASS, ""

        # 步骤4 执行命令：show controller general，查询当前控制器内存信息(Cache Capacity)；
        cache_capacity = self.get_cache_capacity()

        if float(cache_capacity) > PASS_CACHE_CAPACITY:
            return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")
        return CheckStatus.NOT_PASS, self.get_msg("item.not_pass")

    def get_cache_capacity(self):
        # 获取当前控制器内存信息(Cache Capacity)
        results = self.dsl("exec_cli 'show controller general' | vertical_parser")
        capacity_info = results[0].get("Cache Capacity")
        if "TB" in capacity_info:
            cache_capacity = float(capacity_info.replace("TB", "")) * MEMORY_UNIT_CONVERSION
            return cache_capacity
        cache_capacity = float(capacity_info.replace("GB", ""))
        return cache_capacity
