# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from expparser import *
from psdk.dsl import adapter
from psdk.dsl.operator.base_operator import BaseOperator


class ExecLogDsl(BaseOperator):
    def __init__(self, dsl_context):
        BaseOperator.__init__(self, dsl_context)
        self.context = dsl_context.context
        self.matched_data = dsl_context.matched_data
        self.dsl_context = dsl_context

    def get(self):
        parse_key = Literal("exec_log").setResultsName("type")
        a = CharsNotIn("'")
        b = Suppress("'")
        cmd_section = Combine(b + OneOrMore(a) + b).setResultsName("cause_id")
        pattern = parse_key + cmd_section
        pattern.setParseAction(self.base_action)
        return pattern

    def action(self, s, loc, toks):
        self.logger.info("enter {} action ".format(toks.type))
        self.logger.info("cause_id={}".format(toks.cause_id))
        log_type = 'DEFAULT'
        if "log_type" in self.dsl_context.kwargs:
            log_type = self.dsl_context.kwargs.get("log_type")
        flag, match_info, self.matched_data \
            = adapter.exec_log_dsl(self.context, toks.cause_id, log_type)
        self.dsl_context.matched_data = self.matched_data
        self.logger.info("match info={}".format(self.dsl_context.matched_data))
        self.dsl_context.origin_info.append("exec_log " + toks.cause_id)
        if flag:
            self.dsl_context.origin_info.append(
                "match info=" + "\n".join(match_info))
        else:
            self.dsl_context.origin_info.append("no match info")
        return flag
