# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.


class AppContext(object):
    """
    Py进程全局配置
    """
    _instance = None
    gateway = None
    jvm = None

    @classmethod
    def get_jvm(cls):
        return cls.jvm

    @classmethod
    def close_gateway(cls):
        if cls.gateway:
            cls.gateway.close()

    def __new__(cls, *args, **kwargs):
        if cls._instance is None:
            cls._instance = super(AppContext, cls).__new__(cls, *args, **kwargs)
        return cls._instance
