# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

class CheckStatus(object):
    PASS = "PASS"
    NOT_PASS = "NOT_PASS"
    NOT_CHECK = "NOT_CHECK"
    NOT_SUPPORT = "NOT_SUPPORT"
    WARNING = "WARNING"
    UNKNOWN = "UNKNOWN"

    @staticmethod
    def merge_all_ctrl_result(lang, all_ret):
        all_status = []
        all_msgs = []
        for key in all_ret.keys():
            status, ctr_msg = all_ret.get(key)
            if status is not None:
                all_status.append(status)
            if ctr_msg:
                all_msgs.append("node[{}]: {}".format(key, ctr_msg))

        err_msg = "\n".join(all_msgs)
        if not all_status:
            return CheckStatus.NOT_CHECK

        if CheckStatus.NOT_PASS in all_status:
            return CheckStatus.NOT_PASS, err_msg
        if CheckStatus.NOT_CHECK in all_status:
            return CheckStatus.NOT_CHECK, err_msg
        if CheckStatus.NOT_SUPPORT in all_status:
            return CheckStatus.NOT_SUPPORT, err_msg
        if CheckStatus.WARNING in all_status:
            return CheckStatus.WARNING, err_msg
        if CheckStatus.UNKNOWN in all_status:
            return CheckStatus.UNKNOWN, err_msg
        return CheckStatus.PASS, ""
