# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.platform.entity import execute_env as execute_env_module


class PyTask(object):
    """
    执行Py脚本的输入
    对应Java侧的PyTask

    """
    def __init__(self):
        self.script_name = ""
        self.context = None
        self.java_dev = None
        self.sys_path = ""
        self.module_path = ""
        self.method_name = ""
        self.execute_env = None
        self.args = ()
        self.kwargs = {}
        self.execute_type = ""
        self.item_id = ""

    @staticmethod
    def to_py_task(java_task):
        py_task = PyTask()
        py_task.java_dev = java_task.getDevNode()

        py_task.sys_path = java_task.getExecuteEnv().getSysPath()
        py_task.module_path = java_task.getModulePath()
        py_task.method_name = java_task.getMethodName()
        py_task.args = tuple(java_task.getArgs())
        py_task.kwargs = dict(java_task.getKwargs())
        py_task.execute_env = PyTask.to_py_execute_env(java_task.getExecuteEnv())
        return py_task

    @staticmethod
    def to_py_execute_env(java_env):
        # 要求java中类名与python中类名一致
        clz_name = str(java_env.getClass().getName()).split(".")[-1]
        env_obj = getattr(execute_env_module, clz_name).to_py_env(java_env)
        return env_obj


class PyTaskResult(object):
    """
    将java_result包装成python的接口，对应Java侧的PyTaskResult
    """
    def __init__(self, java_result):
        self.java_result = java_result

    def set_py_result(self, result):
        self.set_base_result(result[0], result[1])

    def set_origin_result(self, origin_info):
        self.java_result.setOriginInfo(origin_info)

    def set_base_result(self, status, detail):
        self.java_result.setStatus(status)
        self.java_result.setDetail(detail)
