# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import os
import sys
import threading

from psdk.platform.base.logger import log
from psdk.platform.main.py_task_executor import PyTaskExecutor


class PyEntrance(object):
    """
    java调用的入口
    """
    def __init__(self):
        sys.path.append(os.path.dirname(__file__))

    def executeTask(self, java_task):
        log.debug("run execute task")
        return PyTaskExecutor().run(java_task)

    def submitTask(self, java_task, call_back):
        log.debug("run submit task")
        thread = threading.Thread(target=PyTaskExecutor().run, args=(java_task, call_back))
        thread.start()

    class Java:
        implements = ["com.huawei.ism.IPythonEntrance"]
