# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.platform.protocol.rest import rest_service
from psdk.platform.protocol.rest import rest_constant


class RestCommonService(object):
    def __init__(self, dev_node, rest_type=""):
        self.dev_node = dev_node
        self.rest_type = rest_type
        self.rest_service = rest_service.RestService(dev_node)

    def exec_tlv_cmd(self, tlv_cmd, param_dict):
        uri = rest_constant.TLV_COMMUNICATION
        rest_cmd = {'cmd': tlv_cmd, 'timeout': rest_constant.REST_TIMEOUT}
        rest_param_dict = self.tlv_to_rest_param(param_dict)
        rest_cmd.update({"params": rest_param_dict})
        return self.rest_service.exec_post(uri, rest_cmd)

    @classmethod
    def tlv_to_rest_param(cls, params):
        if params is None:
            return []
        ret = []
        param_dict = {}
        for param in params:
            if len(param) < 2:
                continue
            param_dict["index"] = param[0].get("index")
            param_dict["type"] = param[0].get("type")
            param_dict["value"] = str(param[1])
            ret.append(param_dict)
            param_dict = {}
        return ret
